// Code for 1-cut
#include <oxstd.h>
#include <oxprob.h>
#include <oxdraw.h>

#import "../code/sim_1cut"

main()
{
	decl pvals = <0.01;0.001>, pval, bdiagnostics = FALSE;
	decl ct = 75, n, time = timer(), cm = 10000;

	foreach (pval in pvals)
	{
		for (n = 1; n <= 10; ++n)
		{															 // <0 sigma argument: use t(3) instead of N[0,1]
			Run_1cut(cm, ones(n, 1), 10, ct, pval, TRUE, TRUE, FALSE, -0.4 * sqrt(n), 5, TRUE);	// yes diagnostics, no IIS
		}
	}

	foreach (pval in pvals)
	{
		for (n = 1; n <= 10; ++n)
		{
			Run_1cut(cm, ones(n, 1), 10, ct, pval, TRUE, TRUE, FALSE, -0.4 * sqrt(n), 5, FALSE); // no diagnostics, no IIS
		}
	}

	foreach (pval in pvals)
	{
		for (n = 1; n <= 10; ++n)
		{
			Run_1cut(cm, ones(n, 1), 10, ct, pval, TRUE, TRUE, FALSE, -0.4 * sqrt(n), 5, FALSE, "IIS");	// no diagnostics, IIS
		}
	}
	println("Total time:", timespan(time));
}