// Code for 1-cut
#include <oxstd.h>
#include <oxprob.h>
#include <oxdraw.h>

#import "../code/sim_1cut"

PlotBeta(const cM)
{
	decl mbeta_sel, mbeta_bc2step_sel, mbeta_sel_iis, mbeta_bc2step_sel_iis, i, cbars = 10, n = 5;
	
	[mbeta_sel, mbeta_bc2step_sel] =
		Run_1cut(cM, ones(n, 1), 10, 75, 0.01, TRUE, TRUE, FALSE, -0.4 * sqrt(n), 5, FALSE);

	[mbeta_sel_iis, mbeta_bc2step_sel_iis] =
		Run_1cut(cM, ones(n, 1), 10, 75, 0.01, TRUE, TRUE, FALSE, -0.4 * sqrt(n), 5, FALSE, "IIS");

	for (i = 0; i < 5; ++i)
	{
		DrawDensity(i, mbeta_sel[i][vecindex(mbeta_sel[i][] .!= 0)], sprint("$\\beta_", i + 1, "$"), TRUE, FALSE, FALSE, FALSE, FALSE, 0, 2);
		DrawDensity(i, mbeta_sel_iis[i][vecindex(mbeta_sel_iis[i][] .!= 0)], "", TRUE, FALSE, FALSE, FALSE, FALSE, 0, 3);
	}
	for (i = 5; i < 10; ++i)
	{
		DrawDensity(i, mbeta_sel[i][vecindex(mbeta_sel[i][] .!= 0)], sprint("$\\beta_", i + 1, "$"), FALSE, TRUE, FALSE, FALSE, FALSE, 0, 2);
		DrawDensity(i, mbeta_sel_iis[i][vecindex(mbeta_sel_iis[i][] .!= 0)], "", FALSE, TRUE, FALSE, FALSE, FALSE, 0, 3);
	}
	ShowDrawWindow();

}
main()
{
	PlotBeta(10000);
}