#include <oxstd.h>

#import "../code/sim_autometrics"

main()
{
	decl cm = 1000;
	decl rho = <0.2,0.8>;

	format(1000);
	
	for (decl i = 0; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC_EJ", rho[i]);
		exp.Stepwise("Lasso", 0, -1, 3);		// BIC
		exp.Run(cm);
		delete exp;
	}
	for (decl i = 0; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC_EJ", rho[i]);
		exp.Stepwise("Stepwise", 0, -1, 3);		// BIC
		exp.Run(cm);
		delete exp;
	}
	for (decl i = 0; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC_EJ", rho[i]);
		exp.Stepwise("Lasso", 0, 5, -1);		// true size
		exp.Run(cm);
		delete exp;
	}
	for (decl i = 0; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC_EJ", rho[i]);
		exp.Stepwise("Stepwise", 0, 5, -1);		// true size
		exp.Run(cm);
		delete exp;
	}
	for (decl i = 0; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC_EJ", rho[i]);
		exp.Autometrics(0.05);	   				// 5%
		exp.Run(cm);
		delete exp;
	}
	for (decl i = 0; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC_EJ", rho[i]);
		exp.Autometrics(i == 0 ? 0.11 : 0.15);	// matching p-value
		exp.Run(cm);
		delete exp;
	}
	for (decl i = 1; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC_EJ", rho[i]);
		exp.Autometrics(0.10);					// matching p-value
		exp.Run(cm);
		delete exp;
	}
}