#include <oxstd.h>

#import "../code/sim_autometrics"

main()
{
	decl cm = 1000;
	decl rho = <-0.95,-0.9,-0.8,-0.4,0,0.4,0.8,0.9,0.95>, pvals = <0.01,0.05>;

	format(1000);
	
	for (decl i = 0; i < sizerc(rho); ++i)
	{
		decl exp = new AutometricsExp("JEDC", rho[i]);
		exp.Stepwise("Lasso", 0, -1, 3);				// BIC
		exp.Run(cm);
		delete exp;
	}
	for (decl j = 0; j < sizerc(pvals); ++j)
	{
		for (decl i = 0; i < sizerc(rho); ++i)
		{
			decl exp = new AutometricsExp("JEDC", rho[i]);
			exp.Stepwise("Stepwise", pvals[j]);				// pvalue
			exp.Run(cm);
			delete exp;
		}
		for (decl i = 0; i < sizerc(rho); ++i)
		{
			decl exp = new AutometricsExp("JEDC", rho[i]);
			exp.Autometrics(pvals[j]);	   					// pvalue
			exp.Run(cm);
			delete exp;
		}
	}
}