#include <oxstd.h>

//#define USE_PCFIML
#import "../code/sim_autometrics"

main()
{
	decl cm = 1000;
	decl designs = {"BLcx","BUcx","BUcx_t"}, vrho = <0,0.9>, rho;
	decl delta = <2,2,0.2>, tvals = <2.4,3.2,4.0>, gamma = <10,5,5>;

	format(1000);
	
	foreach (rho in vrho)
	{
		println("\n\n##### rho=", rho);
		for (decl i = 0; i < sizerc(designs); ++i)
		{
			for (decl k = 0; k < sizerc(tvals); ++k)
			{
				decl exp = new AutometricsExp(designs[i], {delta[i], 0, tvals[k], rho,
					SimDesign::USE_CONSTANT_X, SimDesign::SAT_NONE} );
				exp.Autometrics(0.01);
				exp.Run(cm);
				delete exp;
			}
		}
		for (decl i = 0; i < sizerc(designs); ++i)
		{
			for (decl k = 0; k < sizerc(tvals); ++k)
			{
				decl exp = new AutometricsExp(designs[i], {delta[i], 0, tvals[k], rho,
					SimDesign::USE_CONSTANT_U, SimDesign::SAT_NONE} );
				exp.Autometrics(0.01);
				exp.Run(cm);
				delete exp;
			}
		}
	}
}