#include <oxstd.h>
#import  <pcfiml>
#import <lib/normtest>
#import <lib/testres>

PcFimlEx::PcFimlEx()
{
	PcFiml();
	m_cTestLag_AR = m_cTestLag_ARCH = -1;	// -1: use default; 0 is off
	m_dChowFrac = 0.5;

	m_bAutoTest_normality = m_bAutoTest_hetero = TRUE;
}

PcFimlEx::AutometricsComponentMap()
{
	return <>;
}
PcFimlEx::AutometricsRegressorMap()
{
	decl selinfo = GetSelInfo();
	// get the regressors that can be deleted in the parameter order
	// corresponds to the ordered regressors
	return vecindex(selinfo[1] .== Y_VAR .&& selinfo[2] .> 0)'
       ~ vecindex(selinfo[1] .== X_VAR)';
}
PcFimlEx::AutometricsCovarMap()
{
	// get the covariance indices of the free terms
	return ones(1, m_cY) ** (unit(m_cW - m_cU) ~ zeros(m_cW - m_cU, m_cU));
}
PcFimlEx::AutometricsCovar()
{
	return GetCovar();
}
PcFimlEx::AutometricsLowerBounds(const amR, const avR, const aasR, const avRIsStrict)
{
	return 0;
}
PcFimlEx::AutometricsSignificance()
{
	if (m_cW - m_cU == 0)
		return <>;
	if (m_cW >= m_cT)
		return ones(m_cW - m_cU, 1);
	if (m_cY == 1)
		return 2 * tailt(fabs(GetPar()) ./ GetStdErr(), GetcT() - GetcDfLoss())[:m_cW - m_cU - 1];

	decl v = zeros(1, m_cW - m_cU), i;
	for (i = 0; i < m_cW - m_cU; ++i)
		v[i] = doSystemTest(i);

	return v;
}
PcFimlEx::AutometricsCoefficients()
{
	if (m_cY == 1 && m_cW > m_cU)
	{
		decl vp = GetPar();
		if (sizerc(vp))
			return vp[ : m_cW - m_cU - 1];
	}
	return <>;
}
PcFimlEx::AutometricsModelStats()
{
	return <>;
}
PcFimlEx::AutometricsModelStatNames()
{
	return {};
}
PcFimlEx::ArchTest(const cLag)
{
	if (cLag == 0)
		oxrunerror("cLag == 0!");
	if (sizerc(GetResiduals()) <= 1)
		println("GetResiduals, ", sizerc(GetResiduals()));
// Same as PcGets:
	return ::ArchTest(GetResiduals(), 1, cLag, -1, m_fPrint);
// Same as PcGive 12:
//	return ::ArchTest(GetResiduals(), 1, cLag, GetcDfLoss() - 1, m_fPrint);
// Appealing to asymptotic block orthogonality of information:
//	return ::ArchTest(GetResiduals(), 1, cLag, 0, m_fPrint);
}
PcFimlEx::AutometricsDiagnosticNames()
{
	decl as = {};
	decl arlag, archlag;
	[arlag, archlag] = GetLagForTesting();
	
	if (arlag > 0)
		as ~= sprint("AR(", arlag, ")");
	if (archlag > 0)
		as ~= sprint("ARCH(", archlag, ")");
	if (m_bAutoTest_normality)
		as ~= "Normality";
	if (m_bAutoTest_hetero)
		as ~= "Hetero";
	if (m_dChowFrac > 0)
		as ~= sprint("Chow(", m_dChowFrac * 100, "%)");
	return as;
}	
PcFimlEx::AutometricsDiagnostics()
{
	decl arlag, archlag, test, ctest = 0;
	[arlag, archlag] = GetLagForTesting();

	decl alpha = ones(1, m_bAutoTest_normality + m_bAutoTest_hetero +
		(arlag > 0) + (archlag > 0) + (m_dChowFrac > 0));

	if (isnan(m_dLogLik))
		oxrunerror("Model must be estimated first");

	if (arlag > 0)
	{
		if (columns(m_mW) + arlag > rows(m_mW) - 5)
		{
			arlag = rows(m_mW) - 5 - columns(m_mW);
			if (m_fPrint)
				println("AR test: shortened lag length to", arlag);
		}
		test = ArTest(1, arlag);
	    if (sizer(test) == 2)
			alpha[0] = test[1][0];
		++ctest;
	}
	if (archlag > 0)
	{
		test = ArchTest(archlag);
	    if (sizer(test) == 2)
			alpha[ctest] = test[1][0];
		++ctest;
	}

	if (m_bAutoTest_normality)
		alpha[ctest++] = NormalityTest()[1][0];

	if (m_bAutoTest_hetero)
	{
		test = HeteroTest(FALSE, FALSE);
	    if (sizer(test) == 2)
		{
			if (test[0][0] < 0)
				alpha[ctest] = test[1][1];	   // Chi^2 because F not available
			else
				alpha[ctest] = test[1][0];	   // F-form
		}
		else
			alpha[ctest] = 1;	// failed because no regressors: signal success
		++ctest;
	}
	if (m_dChowFrac > 0)
	{
		decl t1 = GetSelStart(), t2 = GetSelEnd(), ct = t2 - t1 + 1; 
		t1 += int(round(ct * m_dChowFrac));
		test = Chow(ObsYear(t1) , ObsPeriod(t1));
		if (sizer(test) == 2)
			alpha[ctest] = isnan(test[1][0]) ? test[1][1] : test[1][0];
	}
	return alpha;
}
PcFimlEx::doSystemTest(const idxDrop)
{
	decl r, b, sign, ftest, df1, df2, c = sizerc(idxDrop), logdetrr;
	if (c == 0)
		return;
	r = dropc(m_mW, idxDrop);
	if (!rows(r))
		return;
	olsc(m_mY, r, &b);
	r = m_mY - r * b;

	logdetrr = logdet((r'r) / m_cT, &sign);
	ftest = 1 - exp(-2 * m_dLogLik / m_cT - logdetrr);
	GetFapproximation(m_cW - c, m_cT, m_cY, c, &ftest, &df1, &df2);
	return tailf(ftest, df1, df2);
}
PcFimlEx::AutometricsStdResiduals()
{
	return IN01Data(m_mResidual) * sqrt((GetcT() - GetcDfLoss()) / GetcT());
}
PcFimlEx::TestExclusions(const vSel, const bDoFTest)
{
	if (m_cW - m_cU == 0 || sizerc(vSel) == 0)
		return <>;

	decl vp, mr, mrtr, test, cx, cr, cdf2 = -1, pval;
	// VAR: select the regressor in all equations
	// SEM: select where appropriate
	vp = GetFreePar();							// current parameter estimates
    mr = vec(vSel);								// mr selects vars for exclusion
	if (m_cY > 1)
	{
		decl i, cx = idiv(sizerc(vp), m_cY);
		for (i = 1; i < m_cY; ++i)								
		    mr |= vec(vSel) + i * cx;
	}
    cr = sizer(mr);
	mrtr = invertgen(GetCovar()[mr][mr], 30);	// mrtr = R * Var(b) * R'
	vp = vp[mr];		                       	// vrbr = Rb - r = Rb here
    test = double(vp' * mrtr * vp);				// (Rb-r)' * inv(mrtr) * (Rb-r)

	if (bDoFTest && m_cY == 1)
	{
		test /= cr;
		cdf2 = GetcT() - GetcDfLoss();
        pval = tailf(test, cr, cdf2);
	}
	else
	{
        pval = tailchi(test, cr);
	}

	return test | pval | cr | cdf2;
}
PcFimlEx::SetTestLag(const cTestLag)
{
	if (isarray(cTestLag))
		m_cTestLag_AR = cTestLag[0], m_cTestLag_ARCH = cTestLag[1];
	else
		m_cTestLag_AR = m_cTestLag_ARCH = cTestLag;
}
PcFimlEx::SetNormalityTest(const bSwitchOn)
{
	m_bAutoTest_normality = (bSwitchOn > 0);
}
PcFimlEx::SetHeteroTest(const bSwitchOn)
{
	m_bAutoTest_hetero = (bSwitchOn > 0);
}
PcFimlEx::GetTestLag()
{
	return { m_cTestLag_AR, m_cTestLag_ARCH};
}
PcFimlEx::GetLagForTesting()
{
	decl arlags, archlags;
    decl nmi, nmj, mar, freq = GetFrequency();

    nmi = min(1 + int((m_cT + 5) / 10), 12);
    nmj = min(int(nmi / 2) + 1, 13);
    mar = min(int((m_cT - m_cW - m_cY - 7) / 2), 13);
    if (mar < 0)  mar = 0;
    nmj = min(nmj, mar);

	arlags = max( min(nmj, freq + 1), 1);
	archlags = max( min(nmj, freq), 1);
	
    return {m_cTestLag_AR < 0 ? arlags : m_cTestLag_AR, m_cTestLag_ARCH < 0 ? archlags : m_cTestLag_ARCH};
}
PcFimlEx::SetChowFrac(const dChowFrac)
{
	m_dChowFrac = dChowFrac;
}
PcFimlEx::GetChowFrac()
{
	return m_dChowFrac;
}
PcFimlEx::SendVarStatusLabels()
{
	return {"Y_VAR", "X_VAR", "U_VAR", "A_VAR"};
}
PcFimlEx::SendVarStatus()
{
	return
        {{ "&Y: endogenous",  'Y', STATUS_GROUP + STATUS_MULTIVARIATE, Y_VAR},
         { "&Z: regressor",   'Z', STATUS_GROUP + STATUS_DEFAULT, X_VAR},
		 { "&U: unrestricted",'U', STATUS_GROUP + STATUS_SPECIAL, U_VAR},
		 { "&A: instrument",  'A', STATUS_GROUP, A_VAR}
		};
}
PcFimlEx::IsImpulseDummy(const sX, const aiYear1, const aiPeriod1, const aiOp,
		const aiYear2, const aiPeriod2)
{
	decl len = sizeof(sX);
	if (len <= 5 || sX[:1] != "I:")
		return FALSE;

	decl year = 0, period = 1, sx = sX[2 : ];

	// Autometrics new style dummy: I:year(period) or I:year1(period1)+I:year2(period2)
	//								sign is + or -, year2=year1+1 or period2=period1+1
	if (strfind(sx, "-") > 0 && strfind(sx, "-") != strfindr(sx, "-"))
	{
		decl month, day;
		if (sscan(&sx, "%d", &year, "-", "%d", &month, "-", "%d", &day, " ") < 3)
			return FALSE;
		period = -1;
		year ~= month ~ day;
	}
	else
	{
		if (sscan(&sx, "%d", &year, "(", "%d", &period, ") ") < 1)
			return FALSE;
	}

	aiYear1[0] = year;
	aiPeriod1[0] = period;
	aiOp[0] = 0;

	// check for +- another dummy
	if (sizeof(sx))
	{
		switch_single (sx[0])
		{	case '-' : aiOp[0] = -1;
		 	case '+' : aiOp[0] = +1;
			default: return FALSE;
		}
		decl y1, p1, y2, p2, op;
		if (!IsImpulseDummy(strtrim(sx[1 : ]), &y1, &p1, &op, &y2, &p2))
			return FALSE;

		aiYear2[0] = year;
		aiPeriod2[0] = period;
	}
	return TRUE;
}
PcFimlEx::IsImpulseDummyOld(const sX, const aiYear, const aiPeriod, const aiDiffLag,
	const aiSumLag, const asBaseName)
{
	decl pos = strfind(sX, ':'), len = sizeof(sX);
	if (pos <= 0)
		return FALSE;

	decl diff = 0, dlag = 0, year = 0, period = 1, type = 1, sumlag = 0, sdum, ispcgets;
	if (pos == len - 2 || pos == len - 3)
	{
		if (sX[pos - 5] != 'I')
			return FALSE;
		// PcGets style dummy: Iyear:period or D#Iyear:period
		ispcgets = TRUE;
		if (sscan(sX[pos - 4 : ], "%d", &year, ":", "%d", &period) != 2)
			return FALSE;
		sdum = sX[pos - 5 : ];	// name from the I onwards
	}
	else if (sX[pos - 1 : pos] == "I:")
	{
		// Autometrics old style dummy: I:year(period) or D#I:year(period) or S#I:year(period)
		ispcgets = FALSE;
		if (strfind(sX, "-") > 0)
		{
			decl month, day;
			if (sscan(sX[pos + 1 : ], "%d", &year, "-", "%d", &month, "-", "%d", &day) < 3)
				return FALSE;
			period = -1;
			year ~= month ~ day;
		}
		else
		{
			if (sscan(sX[pos + 1 : ], "%d", &year, "(", "%d", &period) < 1)
				return FALSE;
		}
		sdum = sX[pos - 1 : ];	 // name from the I onwards
	}
	else
		return FALSE;
	
	// NB: old Autometrics style dummies using D or S where mislabelled: instead of
	// using y-lag(y,1) it used y-lead(y,1)=y-lag(y,-1) for D (equivalent for S).
	if (sX[0] == 'D')
	{
		diff = 1;
		if (sX[1] == 'I')
			dlag = 1;
		else if (sscan(sX[1 : ], "%d", &dlag) != 1)
			return FALSE;
		if (!ispcgets)				
			dlag = -dlag;		// correct labelling error
	}
	else if (sX[0] == 'S')
	{
		diff = 1;
		if (sX[1] == 'I')
			sumlag = 1;
		else if (sscan(sX[1 : ], "%d", &sumlag) != 1)
			return FALSE;
		if (!ispcgets)				
			sumlag = -sumlag;	// correct labelling error
	}
	aiYear[0] = year;
	aiPeriod[0] = period;
	aiDiffLag[0] = dlag;
	aiSumLag[0] = sumlag;
	asBaseName[0] = sdum;
	return TRUE;
}
PcFimlEx::GetAlgebraCode(const asX)
{
	decl i, s, len, lag, pos;
	decl difflag, sumlag, year1, period1, iop, year2, period2, sdum, sexpr, salgebra = "";
	
	for (i = 0; i < sizeof(asX); ++i)
	{
		s = asX[i];
		lag = 0;
	
		// first determine and delete optional lag (VAR_# or VAR_##)
		pos = strfindr(s, '_');
		if (pos > 0)
		{
			sscan(s[pos + 1 : ], &lag);
			s = s[ : pos - 1];
		}
		len = sizeof(s);
		
		if (s[:1] == "Ln" && GetVarIndex(s[2:]) != <>)
		{
			sexpr = sprint("\t\"", s, "\" = log(1 + \"", s[2:], "\");\n");
		}
		else if (s[0] == 'L' && GetVarIndex(s[1:]) != <>)
		{
			sexpr = sprint("\t\"", s, "\" = log(\"", s[1:], "\");\n");
		}
		else if (s[0] == 'D' && GetVarIndex(s[1:]) != <>)
		{
			sexpr = sprint("\t\"", s, "\" = diff(\"", s[1:], "\", 1);\n");
		}
		else if (IsImpulseDummy(s, &year1, &period1, &iop, &year2, &period2))
		{
			if (period1 == -1)
				sexpr = sprint("\t\"", s, "\" = dummydates(", year1[0], "-", year1[1], "-", year1[2], ", ", year1[0], "-", year1[1], "-", year1[2], ")");
			else
				sexpr = sprint("\t\"", s, "\" = dummy(", year1, ", ", period1, ", ", year1, ", ", period1, ")");
			if (iop)
			{
				sexpr ~= iop == -1 ? "-" : "+";
				if (period2 == -1)
					sexpr ~= sprint("dummydates(", year2[0], "-", year2[1], "-", year2[2], ", ", year2[0], "-", year2[1], "-", year2[2], ")");
				else
					sexpr ~= sprint("dummy(", year2, ", ", period2, ", ", year2, ", ", period2, ")");
			}
			sexpr ~= ";\n";
		}
		else if (IsImpulseDummyOld(s, &year1, &period1, &difflag, &sumlag, &sdum))
		{
			if (period1 == -1)
				sexpr = sprint("\t\"", sdum, "\" = dummydates(", year1[0], "-", year1[1], "-", year1[2], ", ", year1[0], "-", year1[1], "-", year1[2], ");\n");
			else
				sexpr = sprint("\t\"", sdum, "\" = dummy(", year1, ", ", period1, ", ", year1, ", ", period1, ");\n");

			if (difflag < 0 || sumlag < 0)
				sexpr ~= "\t// transformation is **forward** difference\n";
			if (difflag == 1 || difflag == -1)
				sexpr ~= sprint("\t\"D", sdum, "\" = diff(\"", sdum, "\", ", difflag, ");\n");
			else if (difflag != 0)
				sexpr ~= sprint("\t\"D", fabs(difflag), sdum, "\" = diff(\"", sdum, "\", ", difflag, ");\n");
			else if (sumlag == 1 || sumlag == -1)
				sexpr ~= sprint("\t\"S", sdum, "\" = \"", sdum, "\" + lag(\"", sdum, "\", ", sumlag, ");\n");
			else if (sumlag != 0)
				sexpr ~= sprint("\t\"S", fabs(sumlag), sdum, "\" = \"", sdum, "\" + lag(\"", sdum, "\", ", sumlag, ");\n");
		}
		else
		{
			continue;
		}
		if (strfind(salgebra, sexpr) == -1)
			salgebra ~= sexpr;
	}
	return salgebra;
}
