#include <oxstd.h>

#import "simstore"
#import "simdesigns"

#import <packages/PcGive/pcgive_ects>

#include "sim_pcgive.oxh"


PcGiveExp::PcGiveExp(const sDGP, const aDGPno)
{
	BaseExp();

	decl model = new PcGive();
		
	model.AutometricsSet("print", 0);
	model.SetPrint(FALSE);	

	// this will hand ownership of m_oModel over to the design
	SelectDesign(model, sDGP, aDGPno, Y_VAR, X_VAR, U_VAR);
}
PcGiveExp::~PcGiveExp()
{
	~BaseExp();
}
/**
Main Autometrics settings.
@param dPValue 	significance for model selection (1 for no selection)
@param sOutliers one of: "none","large","iis","sis","iis+sis","diis","diis+iis"
@param bChopLags TRUE: lag presearch; FALSE: no	lag presearch
*/
PcGiveExp::Autometrics(const dPValue, const sOutliers, const bChopLags)
{
	BaseExp::Autometrics(dPValue, sOutliers, bChopLags);

	m_oDesign.GetRefModelObject().Autometrics(dPValue, sOutliers, bChopLags);
}
/**
Run Stepwise.
*/
PcGiveExp::Stepwise(const sMethod, const dPValue, const maxK, const iCrit)
{
	oxrunerror("Stepwise not supported, use AutometricsExp");
}
/**
Run the experiment.
@param cM 	no of replications
@param iReportSettings 	report Autometrics Settings, default is 1
@param sSaveFirstRepName 	optional filename to save first replication of data set (using Database::Save), default is "" for no saving
*/
PcGiveExp::Run(const cM, const iReportSettings, const sSaveFirstRepName)
{
	// reset the seed: all experiments run off the same seed!
	ranseed(-1);

	decl refmodel = m_oDesign.GetRefModelObject(), asdiag = {};
	if (m_dAutoPval < 1)
	{
		refmodel.Autometrics(m_dAutoPval, m_sAutoOutliers, m_bChopLags);
		for (decl k = 0; k < sizeof(m_asAutoSet); ++k)
		{
			refmodel.AutometricsSet(m_asAutoSet[k], m_aAutoSetVal[k]);
			if (m_asAutoSet[k] == "print")
				refmodel.SetPrint(m_aAutoSetVal[k] > 0);
		}
	}
	CreateStore(cM);

	m_oDesign.PreGenerate(refmodel);
	
	decl i, k, time = timer(), final;
	for (i = 0; i < cM; ++i)
	{
		decl model = clone(m_oDesign.GetRefModelObject());
		
		if (model.GetPrint() > 0)
			println("\n============== experiment ", i+1);

		m_oDesign.Generate(model, i);

		if (i == 0 && isstring(sSaveFirstRepName) && sSaveFirstRepName != "")
			model.Save(sSaveFirstRepName);
		m_oDesign.FormulateModel(model);
		model.Estimate();
		m_oDesign.UndoFormulateModelDeltaY(model);	// in case Dy instead of Y
		StoreModel(model, SimStore::STORE_REP, i);

		m_oDesign.FormulateDGP(model);
		model.Estimate();
		StoreModel(model, SimStore::STORE_DGP, i);

		if (i == 0)		// PcGive: can only get names after estimation
			asdiag = model.AutometricsDiagnosticNames();

		delete model;
	}

	decl ret_val;
	serial		  // serial to keep output together, in case called in parallel loop
	{
		println("\n====================");
		if (iReportSettings)
		{
			println("Model selection: ", "%12s", m_dAutoPval < 1 ? "Autometrics" : "NONE");
			println("replications, M=", "%13d", cM,     "  time", "%25s", timespan(time));
			if (m_dAutoPval < 1)
			{
				println("Autometrics settings");
				println("\t", "Autometrics(", m_dAutoPval, ", ", "%v", m_sAutoOutliers, ", ", m_bChopLags, ");\n");
				println(refmodel.AutometricsGetAll("\tAutometricsSet"));
			}
		}
	
		ret_val = m_oStore.ReportSelection(m_oDesign.GetTitle(), m_oDesign.GetRefUParCount(),
			m_oDesign.GetObsCount(), m_dAutoPval);
		m_oStore.ReportDiagnostics(asdiag);
		
		if (iReportSettings == 2)
			m_oStore.ReportPar({}, {});
	}

	return ret_val;
}
