#ifndef SIMDESIGN_H
#define SIMDESIGN_H

#import  <database>


class SimDesign
{
	SimDesign(const obj, const iYvar, const iXvar, const iUvar);
	~SimDesign();
	SetTitle(const sTitle);
	GetTitle();
	GetRefModelObject();
	SetDGPno(const iDGP);
	GetDGPno();
	virtual CreateDatabase(const sFile, const cTmax, const cXmax, const vSteps);
	virtual CreateReference(const cYlag, const cX, const cXlag, const iConstantMode,
		const bTrend, const cStep, const cTdiscard, const cTest);
	SetDGP(const vPar);
	SetDGPError(const dESE, const dARPar);
	virtual DummySaturation(const sType, const cTdiscard);
	AddImpulseBreakToRefPar(vPar, const dFraction, const dSize, const bUseSteps);
	SetModel(const vPar);
	RemoveFromModel(const asPar);
	SetXCorrelation(const dCorrelation, const iMode);
	SetXAutoCorrelation(const dXautocorr);
	SetRenewX(const bRenewX);
	virtual FormulateReferenceModel(const oClient);
	virtual AddExtrasToReference();
	FormulateModelInReference(const oClient, const vParInGUM, const iConstantMode, const bUseDeltaY);
	FormulateModel(const oClient);
	UndoFormulateModelDeltaY(const oClient);
	FormulateDGP(const oClient);
	virtual GenerateX(const iRep, const cT);
	virtual TransformX1(const mX);
	virtual TransformX2(const mX);
	virtual PreGenerate(const oClient);
	virtual Generate(const oClient, const iRep);
	GetDgpParCount();
	GetSigmaInDGP();
	GetARParInDGP();
	GetRefUParCount();
	GetObsCount();
	GetRefParDGP();
	GetRefParNames();
	GetRefConstantLabel();
	GetObsInitCount();
	UseModelDeltaY(const bUseDiff);
	IsModelDeltaY();
	
public:
	enum
	{
		USE_CONSTANT_NONE,
		USE_CONSTANT_U,
		USE_CONSTANT_X
	}
	enum
	{
		USE_XCOR_MATCONST,
		USE_XCOR_MATPOWIJ,
		USE_XCOR_AUTO
	}
	enum
	{
		SAT_NONE,
		SAT_IIS,
		SAT_SIS,
		SAT_IIS_SIS
	}

protected:

	decl m_oRefModel;			/// the client Modelbase object
	decl m_iYvar, m_iXvar, m_iUvar;	/// the regressor type identifiers
	decl m_sTitle;			/// title (string)
	decl m_iDGP;			/// DGP number (if any)
	decl m_asY, m_asEps, m_asX;	/// names of y, residual and regressors X created in m_oRefModel
	decl m_asStep;			/// optional step dummies added by Create(), with names Step[#:#]

	decl m_bHaveX;			/// TRUE if m_oRefModel has data on X
	decl m_bRenewX;			/// TRUE if data on X is to be renewed for every replication
	
	decl m_cYlag_RM;		/// max Y lag in reference model
	decl m_cX_RM, m_cU_RM;/// max no of X and U variables (at lag 0) in reference model
	decl m_cXlag_RM;		/// lag-length of X's in reference model
	decl m_iConstant_RM;	/// specifies constant in reference model, one of USE_CONSTANT_...
	decl m_bTrend_RM;		/// TRUE: Trend in GUM
	decl m_cStep_RM;		/// no of step dummies in reference model (taken from m_asStep[0:])
	decl m_cTdiscard;		/// no of observations to discard after generation
	decl m_iYear1est, m_iPeriod1est, m_iYear2est, m_iPeriod2est;  /// sample to use in estimation
	decl m_cTest;			/// no of observations in estimation sample

	decl m_asPar_RM;		/// names of the regressors of the reference model
	decl m_vParDGP_RM;		/// DGP coefficients of the reference model (0: excluded)
	decl m_dSigmaDGP;		/// DGP uses N[0,sigma^2]
	decl m_dARParDGP;		/// optional autoregressive error
	decl m_dXcorrelation, m_iXcorrelationMode; /// settings for X correlation
	
	decl m_asDummy;			/// names of dummy saturation terms added to the database
	
	decl m_bModelDeltaY;	/// TRUE: using Dy as dependent variable in FormulateModel
	decl m_vParModelNonZero_RM;	/// model formulation in terms of the reference model
}

#endif // SIMDESIGN_H
