#ifndef SIMDESIGNS_H
#define SIMDESIGNS_H

#import  "simdesign"

class HP : SimDesign
{
	HP(const iDGP, const obj, const iYvar, const iXvar, const iUvar);
	virtual LoadData();
	DiffDb();
	static GetParametersForDGP(const iDGP, const asParDesign);
	virtual SetGUMandDGP(const iDGP, const iConstantMode);
}
class HPBig : HP
{
	HPBig(const iDGP, const obj, const iYvar, const iXvar, const iUvar, const cExtra=10);
	virtual LoadData();
	virtual SetGUMandDGP(const iDGP, const iConstantMode);
	virtual PreGenerate(const oClient);
	decl 	m_cExtra;
}
class JEDC_raw : SimDesign
{
	JEDC_raw(const obj, const iYvar, const iXvar, const iUvar);
	virtual SetGUMandDGP(const iDGP, const cYlag, const cXtot, const cXlag, const cXsignificant,
		const iConstantMode, const cTest, const dRhoZ, const bDGPisTvalue,
		const iDummySaturation, const dFraction, const dSize, const dTrend, const dYlag);
	GetSaturationLabel();
//	SubstituteStepDummies(const asPar, const vPar, const vParSe, const vParPval, const iT1, const iT2);
	decl m_iDummySaturation;
}
class JEDC : JEDC_raw
{
	JEDC(const obj, const iYvar, const iXvar, const iUvar, const dRhoZ=0);
}
class JEDC_EJ : JEDC_raw
{
	JEDC_EJ(const obj, const iYvar, const iXvar, const iUvar, const dRhoZ=0);
}
class Breaks : JEDC_raw
{
	Breaks(const obj, const iYvar, const iXvar, const iUvar, const dFraction, const dSize);
}
class Bc : JEDC_raw
{
	Bc(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode);
}
class B20 : JEDC_raw
{
	B20(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode);
}
class Bct : JEDC_raw
{
	Bct(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode);
}
class MBc : JEDC_raw
{
	MBc(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode);
}
class MBct : JEDC_raw
{
	MBct(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode);
}
class BLc : JEDC_raw
{
	BLc(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode);
}
class BUc : JEDC_raw
{
	BUc(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode, const bUseModelDeltaY);
}
class IUc : JEDC_raw
{
	IUc(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode, const bUseModelDeltaY);
}
class MIUc : JEDC_raw
{
	MIUc(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode, const bUseModelDeltaY);
}
class MBUc : JEDC_raw
{
	MBUc(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const iConstantMode, const bUseModelDeltaY);
}

class JEDCdyn : JEDC_raw
{
	JEDCdyn(const obj, const iYvar, const iXvar, const iUvar);
	virtual SetGUMandDGP(const iDGP, const cYlag, const cXtot, const cXlag, const cXsignificant,
		const iConstantMode, const cTest, const dRhoZ, const bDGPisTvalue,
		const iDummySaturation, const dFraction, const dSize, const dTrend, const dYlag);
}

class BLcx : JEDCdyn
{
	BLcx(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const dTval, const dRho, const iConstantMode, const iSaturation=SimDesign::SAT_IIS);
}
class BUcx : JEDCdyn
{
	BUcx(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const dTval, const dRho, const iConstantMode, const iSaturation=SimDesign::SAT_IIS);
}
class BUcx_t : JEDCdyn
{
	BUcx_t(const obj, const iYvar, const iXvar, const iUvar, const dDeltaDGP, const dSize, const dTval, const dRho, const iConstantMode, const iSaturation=SimDesign::SAT_IIS);
}

class BaseExp
{
	BaseExp();
	~BaseExp();

	virtual SelectDesign(const oModel, const sDGP, const dDGPno, const iYvar, const iXvar, const iUvar);
	CreateStore(const cM);
	virtual StoreModel(const oModel, const iStore, const iRep);

	virtual Autometrics(const dPValue, const sOutliers="", const bChopLags=TRUE);
	virtual AutometricsSet(const sOpt, const val);

	virtual Stepwise(const sMethod, const dPValue, const maxK=-1, const iCrit=0);
	
	decl m_oDesign, m_oStore;
	decl m_sAutoOutliers, m_dAutoPval, m_bChopLags;
	decl m_asAutoSet, m_aAutoSetVal;
	decl m_sMethod, m_maxK, m_iStopCrit;
}

#endif // SIMDESIGNS_H
