#ifndef SIMSTORE_H
#define SIMSTORE_H

class SimStore
{
	SimStore(const vPar, const asPar, const dSigma, const cM, const cTforc=0);
	
	GetStoredPar(const iStore, const iRep, const bUnconditional);
	StoreForecastsFromAverage(const iStore, const iRep, const vAvgForc);
	StoreEncompassing(const iRep, const vEnc);
	StoreDiagnostics(const iStore, const iRep, const vDiag);

	virtual StoreResults(const iStore, const iRep, const iRepStage, const vPar, const vParSE,
		const vParPval, const asPar, const dESE, const dLogLik, const cT,
		const vForc, const vAct);
	virtual ReportPar(asColumn, asColumnForc);
	virtual ReportDiagnostics(const asDiag);
	virtual ReportSelection(const sTitle, const cParU, const cT, const dPVal1, const dDominatingPVal=0.05);
	
public :
	decl m_asPar, m_vPar, m_cParOrig, m_dSigma;
	decl m_cM;

	decl m_mMC_vPar_REP, m_mMC_vParSE_REP, m_mMC_vParPval_REP, m_vMC_dESE_REP,
		m_vMC_dLogLik_REP, m_vMC_dSC_REP, m_vMC_cPar_REP, m_mMC_vForc_REP;
	decl m_vMC_dWeight_REP, m_mMC_vForcAvg_0;
	decl m_mMC_vPar_DGP, m_mMC_vParSE_DGP, m_mMC_vParPval_DGP, m_vMC_dESE_DGP,
		m_vMC_dLogLik_DGP, m_vMC_dSC_DGP, m_vMC_cPar_DGP, m_mMC_vForc_DGP;
	decl m_mMC_vAct_DGP;
	decl m_mMC_vPar_GUM, m_mMC_vParSE_GUM, m_mMC_vParPval_GUM, m_vMC_dESE_GUM,
		m_vMC_dLogLik_GUM, m_vMC_dSC_GUM, m_vMC_cPar_GUM, m_mMC_vForc_GUM;
	decl m_mMC_vPar_RSC, m_mMC_vParSE_RSC, m_mMC_vParPval_RSC, m_vMC_dESE_RSC,
		m_vMC_dLogLik_RSC, m_vMC_dSC_RSC, m_vMC_cPar_RSC, m_mMC_vForc_RSC;
	decl m_vMC_dWeight_RSC, m_vMC_vParCondWeight_RSC, m_mMC_vForcAvg_1, m_mMC_vForcAvg_2;

	decl m_mMC_vEncomp;
	decl m_mMC_vDiagnosticsGUM, m_mMC_vDiagnosticsREP, m_mMC_vDiagnosticsDGP;

	enum
	{
		STORE_REP,
		STORE_DGP,
		STORE_GUM,
		STORE_RSC
	}
	enum
	{
		STORE_FORC_AVG0,
		STORE_FORC_AVG1,
		STORE_FORC_AVG2
	}

}

#endif // SIMSTORE_H
