#include <oxstd.h>
#include <oxprob.h>
#include <oxdraw.h>

URMSE(const mBeta, const vBetaDGP)
{
	return sqrt(meanr(sqr(mBeta - vBetaDGP')));
}
CRMSE(const mBeta, const vBetaDGP)
{
	decl counts = sumr(mBeta .!= 0);
	return counts .== 0 .? vBetaDGP' .: sqrt(sumr(sqr((mBeta .!= 0) .* (mBeta - vBetaDGP'))) ./ counts);
}
UBIAS(const mBeta, const vBetaDGP)
{
	return meanr((mBeta - vBetaDGP'));
}
CBIAS(const mBeta, const vBetaDGP)
{
	decl counts = sumr(mBeta .!= 0);
	return counts .== 0 .? vBetaDGP' .: sumr( ((mBeta .!= 0) .* (mBeta - vBetaDGP')) ./ counts);
}
CMEAN(const mBeta)
{
	decl counts = sumr(mBeta .!= 0);
	return counts .== 0 .? counts .: sumr(mBeta) ./ counts;
}
GetBiasCorrections(const vBeta, dTstat, c_alpha)
{
	decl bc1step, bc2step;
	decl drs = (densn(c_alpha-dTstat)-densn(-c_alpha-dTstat)) ./ (tailn(c_alpha-dTstat)+probn(-c_alpha-dTstat));
	decl dtbars = dTstat - drs;
	decl drbars = (densn(c_alpha-dtbars)-densn(-c_alpha-dtbars)) ./ (tailn(c_alpha-dtbars)+probn(-c_alpha-dtbars));
	decl dtbarbars = dTstat - drbars;

	// it doesn't matter if absolute t-values are used or not:
	// if dTstat is signed, drs and drbars will also be
	bc1step = fabs(dTstat) .> c_alpha .? vBeta .* (1 - (drs ./ dTstat)) .: 0;		 
	bc2step = fabs(dTstat) .> c_alpha .? vBeta .* (1 - (drbars ./ dTstat)) .: 0;

	return {bc1step, bc2step};
}
PrintSelectionAverages(beta_dgp, mbeta, mbeta_bc1step, mbeta_bc2step, bCompact)
{
	decl cats = reverser(unique(beta_dgp)), sel, i, cc = sizerc(cats);

	println("\nBiases and RMSEs, average by coefficient values:");
	for (i = bCompact ? cc : 0; i <= sizerc(cats) + 1; ++i)
	{
		if (i < cc)
		{
			sel = vecindex(beta_dgp, cats[i]);
			print("For DGP value: ", cats[i]);
		}
		else if (i == cc)
		{
			sel = vecindex(beta_dgp);
			print("For non-zero DGP values");
		}
		else if (i == cc + 1)
		{
			sel = vecindex(!beta_dgp);
			if (sizerc(sel) == 0)
				continue;
			print("For zero DGP values");
		}
		if (sizerc(mbeta_bc1step))
		{
			println("%c", {"estimated", "BC 1-step", "BC 2-step"}, "%r", {"UBIAS","URMSE","CBIAS","CRMSE"},
				(meanc(UBIAS(mbeta, beta_dgp)[sel]) ~ meanc(UBIAS(mbeta_bc1step, beta_dgp)[sel]) ~ meanc(UBIAS(mbeta_bc2step, beta_dgp)[sel]))
			  |	(meanc(URMSE(mbeta, beta_dgp)[sel]) ~ meanc(URMSE(mbeta_bc1step, beta_dgp)[sel]) ~ meanc(URMSE(mbeta_bc2step, beta_dgp)[sel]))
			  |	(meanc(CBIAS(mbeta, beta_dgp)[sel]) ~ meanc(CBIAS(mbeta_bc1step, beta_dgp)[sel]) ~ meanc(CBIAS(mbeta_bc2step, beta_dgp)[sel]))
			  |	(meanc(CRMSE(mbeta, beta_dgp)[sel]) ~ meanc(CRMSE(mbeta_bc1step, beta_dgp)[sel]) ~ meanc(CRMSE(mbeta_bc2step, beta_dgp)[sel])) );
		}
		else
		{
			println("%c", {"estimated"}, "%r", {"UBIAS","URMSE","CBIAS","CRMSE"},
				meanc(UBIAS(mbeta, beta_dgp)[sel])
			  |	meanc(URMSE(mbeta, beta_dgp)[sel])
			  |	meanc(CBIAS(mbeta, beta_dgp)[sel])
			  |	meanc(CRMSE(mbeta, beta_dgp)[sel]) );
		}
	}
}
InfoCrit(const dLogLik, const cP, const cT)
{
	// print report
	decl v = zeros(3, sizec(dLogLik));
	v[0][] = 2 * (cP - dLogLik) ./ cT;				    // AIC
	v[1][] = 2 * (cP .* log(log(cT)) - dLogLik) ./ cT;  // HQ
	v[2][] = (cP .* log(cT) - 2 * dLogLik) ./ cT;		// SC
	return v;
}
